<?php
require_once 'admin_config.php';
requireAdminAuth(); // Ensure only admins can access this page

require_once '../header.php'; // Include header for consistent styling
?>

<div class="container bg-dark text-white mt-5">
    <div class="card bg-dark text-white border-secondary">
        <div class="card-header bg-dark border-secondary">
            <h3 class="mb-0">لوحة تحكم الأدمن</h3>
        </div>
        <div class="card-body">
            <p class="lead">مرحباً بك في لوحة تحكم الأدمن. يمكنك إدارة المستخدمين، الطلبات، والخدمات من هنا.</p>
            
            <div class="row mt-4">
                <div class="col-md-4 mb-3">
                    <div class="card text-center bg-dark text-white border-secondary">
                        <div class="card-body">
                            <i class="bi bi-person-fill display-4"></i>
                            <h5 class="card-title mt-3">إدارة المستخدمين</h5>
                            <p class="card-text">عرض وتعديل المستخدمين.</p>
                            <a href="admin_users.php" class="btn btn-light btn-sm">اذهب</a>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 mb-3">
                    <div class="card text-center bg-dark text-white border-secondary">
                        <div class="card-body">
                            <i class="bi bi-box-seam display-4"></i>
                            <h5 class="card-title mt-3">إدارة الطلبات</h5>
                            <p class="card-text">مراجعة وقبول الطلبات.</p>
                            <a href="admin_orders.php" class="btn btn-light btn-sm">اذهب</a>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 mb-3">
                    <div class="card text-center bg-dark text-white border-secondary">
                        <div class="card-body">
                            <i class="bi bi-grid-fill display-4"></i>
                            <h5 class="card-title mt-3">إدارة الخدمات</h5>
                            <p class="card-text">إضافة وتعديل الخدمات.</p>
                            <a href="admin_services.php" class="btn btn-light btn-sm">اذهب</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php require_once '../footer.php'; ?> 